/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.helpers;

import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.blue.Barrier;
import com.megacrit.cardcrawl.cards.blue.Beam;
import com.megacrit.cardcrawl.cards.blue.Boom;
import com.megacrit.cardcrawl.cards.blue.Cannonball;
import com.megacrit.cardcrawl.cards.blue.CompressionMold;
import com.megacrit.cardcrawl.cards.blue.CoverFire;
import com.megacrit.cardcrawl.cards.blue.DayOfTheDead;
import com.megacrit.cardcrawl.cards.blue.Defend_Blue;
import com.megacrit.cardcrawl.cards.blue.Desperado;
import com.megacrit.cardcrawl.cards.blue.FanTheHammer;
import com.megacrit.cardcrawl.cards.blue.FullMetalJacket;
import com.megacrit.cardcrawl.cards.blue.GatlingArm;
import com.megacrit.cardcrawl.cards.blue.Grapeshot;
import com.megacrit.cardcrawl.cards.blue.HeavySlug;
import com.megacrit.cardcrawl.cards.blue.HiddenChamber;
import com.megacrit.cardcrawl.cards.blue.Hyperlight;
import com.megacrit.cardcrawl.cards.blue.IAmTheGun;
import com.megacrit.cardcrawl.cards.blue.Incendiary;
import com.megacrit.cardcrawl.cards.blue.IronCross;
import com.megacrit.cardcrawl.cards.blue.Laser;
import com.megacrit.cardcrawl.cards.blue.LuckyBullet;
import com.megacrit.cardcrawl.cards.blue.MagicBullet;
import com.megacrit.cardcrawl.cards.blue.MagicMagnet;
import com.megacrit.cardcrawl.cards.blue.MetalSlug;
import com.megacrit.cardcrawl.cards.blue.Munitions;
import com.megacrit.cardcrawl.cards.blue.Overflow;
import com.megacrit.cardcrawl.cards.blue.Pellet;
import com.megacrit.cardcrawl.cards.blue.PoisonSlug;
import com.megacrit.cardcrawl.cards.blue.PressureBubble;
import com.megacrit.cardcrawl.cards.blue.Quickshot;
import com.megacrit.cardcrawl.cards.blue.Quicksilver;
import com.megacrit.cardcrawl.cards.blue.Railgun;
import com.megacrit.cardcrawl.cards.blue.Reload;
import com.megacrit.cardcrawl.cards.blue.Repeater;
import com.megacrit.cardcrawl.cards.blue.Reprogram;
import com.megacrit.cardcrawl.cards.blue.Ricochet;
import com.megacrit.cardcrawl.cards.blue.ScrapLauncher;
import com.megacrit.cardcrawl.cards.blue.ShockSlug;
import com.megacrit.cardcrawl.cards.blue.Slug;
import com.megacrit.cardcrawl.cards.blue.Sparklers;
import com.megacrit.cardcrawl.cards.blue.SpreadGun;
import com.megacrit.cardcrawl.cards.blue.Stash;
import com.megacrit.cardcrawl.cards.blue.SystemUpdate;
import com.megacrit.cardcrawl.cards.blue.Tranquilizer;
import com.megacrit.cardcrawl.cards.blue.Transmute;
import com.megacrit.cardcrawl.cards.blue.Undo;
import com.megacrit.cardcrawl.cards.blue.WarningShots;
import com.megacrit.cardcrawl.cards.blue.XBeam;
import com.megacrit.cardcrawl.cards.colorless.Apotheosis;
import com.megacrit.cardcrawl.cards.colorless.BandageUp;
import com.megacrit.cardcrawl.cards.colorless.Blind;
import com.megacrit.cardcrawl.cards.colorless.DarkShackles;
import com.megacrit.cardcrawl.cards.colorless.DeepBreath;
import com.megacrit.cardcrawl.cards.colorless.DramaticEntrance;
import com.megacrit.cardcrawl.cards.colorless.Enlightenment;
import com.megacrit.cardcrawl.cards.colorless.Finesse;
import com.megacrit.cardcrawl.cards.colorless.FlashOfSteel;
import com.megacrit.cardcrawl.cards.colorless.GoodInstincts;
import com.megacrit.cardcrawl.cards.colorless.JAX;
import com.megacrit.cardcrawl.cards.colorless.JackOfAllTrades;
import com.megacrit.cardcrawl.cards.colorless.Madness;
import com.megacrit.cardcrawl.cards.colorless.MasterOfStrategy;
import com.megacrit.cardcrawl.cards.colorless.MindBlast;
import com.megacrit.cardcrawl.cards.colorless.Panacea;
import com.megacrit.cardcrawl.cards.colorless.Panache;
import com.megacrit.cardcrawl.cards.colorless.Purity;
import com.megacrit.cardcrawl.cards.colorless.SadisticNature;
import com.megacrit.cardcrawl.cards.colorless.SecretTechnique;
import com.megacrit.cardcrawl.cards.colorless.SecretWeapon;
import com.megacrit.cardcrawl.cards.colorless.Shiv;
import com.megacrit.cardcrawl.cards.colorless.SwiftStrike;
import com.megacrit.cardcrawl.cards.colorless.ThinkingAhead;
import com.megacrit.cardcrawl.cards.colorless.Transmutation;
import com.megacrit.cardcrawl.cards.colorless.Trip;
import com.megacrit.cardcrawl.cards.curses.Clumsy;
import com.megacrit.cardcrawl.cards.curses.Decay;
import com.megacrit.cardcrawl.cards.curses.Doubt;
import com.megacrit.cardcrawl.cards.curses.Injury;
import com.megacrit.cardcrawl.cards.curses.Necronomicurse;
import com.megacrit.cardcrawl.cards.curses.Normality;
import com.megacrit.cardcrawl.cards.curses.Pain;
import com.megacrit.cardcrawl.cards.curses.Parasite;
import com.megacrit.cardcrawl.cards.curses.Regret;
import com.megacrit.cardcrawl.cards.curses.Writhe;
import com.megacrit.cardcrawl.cards.green.AThousandCuts;
import com.megacrit.cardcrawl.cards.green.Accuracy;
import com.megacrit.cardcrawl.cards.green.Acrobatics;
import com.megacrit.cardcrawl.cards.green.Adrenaline;
import com.megacrit.cardcrawl.cards.green.AfterImage;
import com.megacrit.cardcrawl.cards.green.Alchemize;
import com.megacrit.cardcrawl.cards.green.AllOutAttack;
import com.megacrit.cardcrawl.cards.green.Backflip;
import com.megacrit.cardcrawl.cards.green.Backstab;
import com.megacrit.cardcrawl.cards.green.Bane;
import com.megacrit.cardcrawl.cards.green.Bite_Green;
import com.megacrit.cardcrawl.cards.green.BladeDance;
import com.megacrit.cardcrawl.cards.green.Blur;
import com.megacrit.cardcrawl.cards.green.BouncingFlask;
import com.megacrit.cardcrawl.cards.green.BulletTime;
import com.megacrit.cardcrawl.cards.green.Burst;
import com.megacrit.cardcrawl.cards.green.CalculatedGamble;
import com.megacrit.cardcrawl.cards.green.Caltrops;
import com.megacrit.cardcrawl.cards.green.Catalyst;
import com.megacrit.cardcrawl.cards.green.Choke;
import com.megacrit.cardcrawl.cards.green.CloakAndDagger;
import com.megacrit.cardcrawl.cards.green.Concentrate;
import com.megacrit.cardcrawl.cards.green.CorpseExplosion;
import com.megacrit.cardcrawl.cards.green.CripplingPoison;
import com.megacrit.cardcrawl.cards.green.DaggerSpray;
import com.megacrit.cardcrawl.cards.green.DaggerThrow;
import com.megacrit.cardcrawl.cards.green.Dash;
import com.megacrit.cardcrawl.cards.green.DeadlyPoison;
import com.megacrit.cardcrawl.cards.green.Defend_Green;
import com.megacrit.cardcrawl.cards.green.Deflect;
import com.megacrit.cardcrawl.cards.green.DieDieDie;
import com.megacrit.cardcrawl.cards.green.Distraction;
import com.megacrit.cardcrawl.cards.green.DodgeAndRoll;
import com.megacrit.cardcrawl.cards.green.Doppelganger;
import com.megacrit.cardcrawl.cards.green.EndlessAgony;
import com.megacrit.cardcrawl.cards.green.Envenom;
import com.megacrit.cardcrawl.cards.green.EscapePlan;
import com.megacrit.cardcrawl.cards.green.Eviscerate;
import com.megacrit.cardcrawl.cards.green.Expertise;
import com.megacrit.cardcrawl.cards.green.Finisher;
import com.megacrit.cardcrawl.cards.green.Flechettes;
import com.megacrit.cardcrawl.cards.green.FlyingKnee;
import com.megacrit.cardcrawl.cards.green.Footwork;
import com.megacrit.cardcrawl.cards.green.GlassKnife;
import com.megacrit.cardcrawl.cards.green.GrandFinale;
import com.megacrit.cardcrawl.cards.green.HeelHook;
import com.megacrit.cardcrawl.cards.green.InfiniteBlades;
import com.megacrit.cardcrawl.cards.green.LegSweep;
import com.megacrit.cardcrawl.cards.green.Malaise;
import com.megacrit.cardcrawl.cards.green.MasterfulStab;
import com.megacrit.cardcrawl.cards.green.Neutralize;
import com.megacrit.cardcrawl.cards.green.Nightmare;
import com.megacrit.cardcrawl.cards.green.NoxiousFumes;
import com.megacrit.cardcrawl.cards.green.Outmaneuver;
import com.megacrit.cardcrawl.cards.green.PhantasmalKiller;
import com.megacrit.cardcrawl.cards.green.PiercingWail;
import com.megacrit.cardcrawl.cards.green.PoisonedStab;
import com.megacrit.cardcrawl.cards.green.Predator;
import com.megacrit.cardcrawl.cards.green.Prepared;
import com.megacrit.cardcrawl.cards.green.QuickSlash;
import com.megacrit.cardcrawl.cards.green.Reflex;
import com.megacrit.cardcrawl.cards.green.RiddleWithHoles;
import com.megacrit.cardcrawl.cards.green.Setup;
import com.megacrit.cardcrawl.cards.green.Skewer;
import com.megacrit.cardcrawl.cards.green.Slice;
import com.megacrit.cardcrawl.cards.green.StormOfSteel;
import com.megacrit.cardcrawl.cards.green.Strike_Green;
import com.megacrit.cardcrawl.cards.green.SuckerPunch;
import com.megacrit.cardcrawl.cards.green.Survivor;
import com.megacrit.cardcrawl.cards.green.Tactician;
import com.megacrit.cardcrawl.cards.green.Terror;
import com.megacrit.cardcrawl.cards.green.ToolsOfTheTrade;
import com.megacrit.cardcrawl.cards.green.UnderhandedStrike;
import com.megacrit.cardcrawl.cards.green.Unload;
import com.megacrit.cardcrawl.cards.green.WellLaidPlans;
import com.megacrit.cardcrawl.cards.green.WraithForm;
import com.megacrit.cardcrawl.cards.red.Anger;
import com.megacrit.cardcrawl.cards.red.Armaments;
import com.megacrit.cardcrawl.cards.red.Barricade;
import com.megacrit.cardcrawl.cards.red.Bash;
import com.megacrit.cardcrawl.cards.red.BattleTrance;
import com.megacrit.cardcrawl.cards.red.Berserk;
import com.megacrit.cardcrawl.cards.red.Bite_Red;
import com.megacrit.cardcrawl.cards.red.BloodForBlood;
import com.megacrit.cardcrawl.cards.red.Bloodletting;
import com.megacrit.cardcrawl.cards.red.Bludgeon;
import com.megacrit.cardcrawl.cards.red.BodySlam;
import com.megacrit.cardcrawl.cards.red.Brutality;
import com.megacrit.cardcrawl.cards.red.BurningPact;
import com.megacrit.cardcrawl.cards.red.Carnage;
import com.megacrit.cardcrawl.cards.red.Clash;
import com.megacrit.cardcrawl.cards.red.Cleave;
import com.megacrit.cardcrawl.cards.red.Clothesline;
import com.megacrit.cardcrawl.cards.red.Combust;
import com.megacrit.cardcrawl.cards.red.Corruption;
import com.megacrit.cardcrawl.cards.red.DarkEmbrace;
import com.megacrit.cardcrawl.cards.red.Defend_Red;
import com.megacrit.cardcrawl.cards.red.DemonForm;
import com.megacrit.cardcrawl.cards.red.Disarm;
import com.megacrit.cardcrawl.cards.red.DoubleTap;
import com.megacrit.cardcrawl.cards.red.Dropkick;
import com.megacrit.cardcrawl.cards.red.DualWield;
import com.megacrit.cardcrawl.cards.red.Entrench;
import com.megacrit.cardcrawl.cards.red.Evolve;
import com.megacrit.cardcrawl.cards.red.Exhume;
import com.megacrit.cardcrawl.cards.red.Feed;
import com.megacrit.cardcrawl.cards.red.FeelNoPain;
import com.megacrit.cardcrawl.cards.red.FiendFire;
import com.megacrit.cardcrawl.cards.red.FireBreathing;
import com.megacrit.cardcrawl.cards.red.FlameBarrier;
import com.megacrit.cardcrawl.cards.red.Flex;
import com.megacrit.cardcrawl.cards.red.GhostlyArmor;
import com.megacrit.cardcrawl.cards.red.Havoc;
import com.megacrit.cardcrawl.cards.red.Headbutt;
import com.megacrit.cardcrawl.cards.red.HeavyBlade;
import com.megacrit.cardcrawl.cards.red.Hemokinesis;
import com.megacrit.cardcrawl.cards.red.Immolate;
import com.megacrit.cardcrawl.cards.red.Impervious;
import com.megacrit.cardcrawl.cards.red.InfernalBlade;
import com.megacrit.cardcrawl.cards.red.Inflame;
import com.megacrit.cardcrawl.cards.red.Intimidate;
import com.megacrit.cardcrawl.cards.red.IronWave;
import com.megacrit.cardcrawl.cards.red.Juggernaut;
import com.megacrit.cardcrawl.cards.red.LimitBreak;
import com.megacrit.cardcrawl.cards.red.Metallicize;
import com.megacrit.cardcrawl.cards.red.Offering;
import com.megacrit.cardcrawl.cards.red.PerfectedStrike;
import com.megacrit.cardcrawl.cards.red.PommelStrike;
import com.megacrit.cardcrawl.cards.red.PowerThrough;
import com.megacrit.cardcrawl.cards.red.Pummel;
import com.megacrit.cardcrawl.cards.red.Rage;
import com.megacrit.cardcrawl.cards.red.Rampage;
import com.megacrit.cardcrawl.cards.red.Reaper;
import com.megacrit.cardcrawl.cards.red.RecklessCharge;
import com.megacrit.cardcrawl.cards.red.Rupture;
import com.megacrit.cardcrawl.cards.red.SearingBlow;
import com.megacrit.cardcrawl.cards.red.SecondWind;
import com.megacrit.cardcrawl.cards.red.SeeingRed;
import com.megacrit.cardcrawl.cards.red.Sentinel;
import com.megacrit.cardcrawl.cards.red.SeverSoul;
import com.megacrit.cardcrawl.cards.red.Shockwave;
import com.megacrit.cardcrawl.cards.red.ShrugItOff;
import com.megacrit.cardcrawl.cards.red.SpotWeakness;
import com.megacrit.cardcrawl.cards.red.Strike_Red;
import com.megacrit.cardcrawl.cards.red.SwordBoomerang;
import com.megacrit.cardcrawl.cards.red.ThunderClap;
import com.megacrit.cardcrawl.cards.red.TrueGrit;
import com.megacrit.cardcrawl.cards.red.TwinStrike;
import com.megacrit.cardcrawl.cards.red.Uppercut;
import com.megacrit.cardcrawl.cards.red.Warcry;
import com.megacrit.cardcrawl.cards.red.Whirlwind;
import com.megacrit.cardcrawl.cards.red.WildStrike;
import com.megacrit.cardcrawl.cards.status.Burn;
import com.megacrit.cardcrawl.cards.status.Dazed;
import com.megacrit.cardcrawl.cards.status.Wound;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.metrics.LeaderboardPoster;
import com.megacrit.cardcrawl.random.Random;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CardLibrary {
    private static final Logger logger = LogManager.getLogger(CardLibrary.class.getName());
    public static int totalCardCount = 0;
    public static HashMap<String, AbstractCard> cards = new HashMap();
    private static HashMap<String, AbstractCard> curses = new HashMap();
    public static int redCards = 0;
    public static int greenCards = 0;
    public static int blueCards = 0;
    public static int colorlessCards = 0;
    public static int curseCards = 0;
    public static int seenRedCards = 0;
    public static int seenGreenCards = 0;
    public static int seenBlueCards = 0;
    public static int seenColorlessCards = 0;
    public static int seenCurseCards = 0;

    public static void initialize() {
        long startTime = System.currentTimeMillis();
        CardLibrary.addRedCards();
        CardLibrary.addGreenCards();
        if (Settings.isDev) {
            CardLibrary.addBlueCards();
        }
        CardLibrary.addColorlessCards();
        CardLibrary.addCurseCards();
        logger.info("Card load time: " + (System.currentTimeMillis() - startTime) + "ms with " + cards.size() + " cards");
        logger.info(redCards + "/75 (Red)");
        logger.info(greenCards + "/75 (Green)");
        logger.info(blueCards + "/75 (Blue)");
        logger.info(colorlessCards + "/20 (Colorless)");
        logger.info(curseCards + "/10 (Curse)");
        logger.info("3/3 (Status)");
    }

    private static void addRedCards() {
        CardLibrary.add(new Anger());
        CardLibrary.add(new Armaments());
        CardLibrary.add(new Barricade());
        CardLibrary.add(new Bash());
        CardLibrary.add(new BattleTrance());
        CardLibrary.add(new Berserk());
        CardLibrary.add(new Bite_Red());
        CardLibrary.add(new BloodForBlood());
        CardLibrary.add(new Bloodletting());
        CardLibrary.add(new Bludgeon());
        CardLibrary.add(new BodySlam());
        CardLibrary.add(new Brutality());
        CardLibrary.add(new BurningPact());
        CardLibrary.add(new Carnage());
        CardLibrary.add(new Clash());
        CardLibrary.add(new Cleave());
        CardLibrary.add(new Clothesline());
        CardLibrary.add(new Combust());
        CardLibrary.add(new Corruption());
        CardLibrary.add(new DarkEmbrace());
        CardLibrary.add(new Defend_Red());
        CardLibrary.add(new DemonForm());
        CardLibrary.add(new Disarm());
        CardLibrary.add(new DoubleTap());
        CardLibrary.add(new Dropkick());
        CardLibrary.add(new DualWield());
        CardLibrary.add(new Entrench());
        CardLibrary.add(new Evolve());
        CardLibrary.add(new Exhume());
        CardLibrary.add(new Feed());
        CardLibrary.add(new FeelNoPain());
        CardLibrary.add(new FiendFire());
        CardLibrary.add(new FireBreathing());
        CardLibrary.add(new FlameBarrier());
        CardLibrary.add(new Flex());
        CardLibrary.add(new GhostlyArmor());
        CardLibrary.add(new Havoc());
        CardLibrary.add(new Headbutt());
        CardLibrary.add(new HeavyBlade());
        CardLibrary.add(new Hemokinesis());
        CardLibrary.add(new Immolate());
        CardLibrary.add(new Impervious());
        CardLibrary.add(new InfernalBlade());
        CardLibrary.add(new Inflame());
        CardLibrary.add(new Intimidate());
        CardLibrary.add(new IronWave());
        CardLibrary.add(new Juggernaut());
        CardLibrary.add(new LimitBreak());
        CardLibrary.add(new Metallicize());
        CardLibrary.add(new Offering());
        CardLibrary.add(new PerfectedStrike());
        CardLibrary.add(new PommelStrike());
        CardLibrary.add(new PowerThrough());
        CardLibrary.add(new Pummel());
        CardLibrary.add(new Rage());
        CardLibrary.add(new Rampage());
        CardLibrary.add(new Reaper());
        CardLibrary.add(new RecklessCharge());
        CardLibrary.add(new Rupture());
        CardLibrary.add(new SearingBlow());
        CardLibrary.add(new SecondWind());
        CardLibrary.add(new SeeingRed());
        CardLibrary.add(new Sentinel());
        CardLibrary.add(new SeverSoul());
        CardLibrary.add(new Shockwave());
        CardLibrary.add(new ShrugItOff());
        CardLibrary.add(new SpotWeakness());
        CardLibrary.add(new Strike_Red());
        CardLibrary.add(new SwordBoomerang());
        CardLibrary.add(new ThunderClap());
        CardLibrary.add(new TrueGrit());
        CardLibrary.add(new TwinStrike());
        CardLibrary.add(new Uppercut());
        CardLibrary.add(new Warcry());
        CardLibrary.add(new Whirlwind());
        CardLibrary.add(new WildStrike());
    }

    private static void addGreenCards() {
        CardLibrary.add(new Accuracy());
        CardLibrary.add(new Acrobatics());
        CardLibrary.add(new Adrenaline());
        CardLibrary.add(new AfterImage());
        CardLibrary.add(new AllOutAttack());
        CardLibrary.add(new AThousandCuts());
        CardLibrary.add(new Backflip());
        CardLibrary.add(new Backstab());
        CardLibrary.add(new Bane());
        CardLibrary.add(new Bite_Green());
        CardLibrary.add(new BladeDance());
        CardLibrary.add(new Blur());
        CardLibrary.add(new BouncingFlask());
        CardLibrary.add(new BulletTime());
        CardLibrary.add(new Burst());
        CardLibrary.add(new CalculatedGamble());
        CardLibrary.add(new Caltrops());
        CardLibrary.add(new Catalyst());
        CardLibrary.add(new Choke());
        CardLibrary.add(new CloakAndDagger());
        CardLibrary.add(new Concentrate());
        CardLibrary.add(new CorpseExplosion());
        CardLibrary.add(new CripplingPoison());
        CardLibrary.add(new DaggerSpray());
        CardLibrary.add(new DaggerThrow());
        CardLibrary.add(new Dash());
        CardLibrary.add(new DeadlyPoison());
        CardLibrary.add(new Defend_Green());
        CardLibrary.add(new Deflect());
        CardLibrary.add(new DieDieDie());
        CardLibrary.add(new Distraction());
        CardLibrary.add(new DodgeAndRoll());
        CardLibrary.add(new Doppelganger());
        CardLibrary.add(new EndlessAgony());
        CardLibrary.add(new Envenom());
        CardLibrary.add(new EscapePlan());
        CardLibrary.add(new Eviscerate());
        CardLibrary.add(new Finisher());
        CardLibrary.add(new Flechettes());
        CardLibrary.add(new FlyingKnee());
        CardLibrary.add(new Footwork());
        CardLibrary.add(new GlassKnife());
        CardLibrary.add(new GrandFinale());
        CardLibrary.add(new HeelHook());
        CardLibrary.add(new InfiniteBlades());
        CardLibrary.add(new LegSweep());
        CardLibrary.add(new Malaise());
        CardLibrary.add(new MasterfulStab());
        CardLibrary.add(new Neutralize());
        CardLibrary.add(new NoxiousFumes());
        CardLibrary.add(new Outmaneuver());
        CardLibrary.add(new PhantasmalKiller());
        CardLibrary.add(new PiercingWail());
        CardLibrary.add(new PoisonedStab());
        CardLibrary.add(new Predator());
        CardLibrary.add(new Prepared());
        CardLibrary.add(new QuickSlash());
        CardLibrary.add(new Reflex());
        CardLibrary.add(new RiddleWithHoles());
        CardLibrary.add(new Skewer());
        CardLibrary.add(new Slice());
        CardLibrary.add(new StormOfSteel());
        CardLibrary.add(new Strike_Green());
        CardLibrary.add(new SuckerPunch());
        CardLibrary.add(new Survivor());
        CardLibrary.add(new Tactician());
        CardLibrary.add(new Terror());
        CardLibrary.add(new ToolsOfTheTrade());
        CardLibrary.add(new UnderhandedStrike());
        CardLibrary.add(new Unload());
        CardLibrary.add(new WellLaidPlans());
        CardLibrary.add(new WraithForm());
        CardLibrary.add(new Setup());
        CardLibrary.add(new Alchemize());
        CardLibrary.add(new Nightmare());
        if (Settings.isBeta) {
            CardLibrary.add(new Expertise());
        }
    }

    private static void addCrowbotBlueCards() {
    }

    private static void addBlueCards() {
        CardLibrary.add(new Boom());
        CardLibrary.add(new Defend_Blue());
        CardLibrary.add(new HeavySlug());
        CardLibrary.add(new Slug());
        CardLibrary.add(new Beam());
        CardLibrary.add(new Cannonball());
        CardLibrary.add(new FullMetalJacket());
        CardLibrary.add(new Grapeshot());
        CardLibrary.add(new Hyperlight());
        CardLibrary.add(new Laser());
        CardLibrary.add(new MagicBullet());
        CardLibrary.add(new MetalSlug());
        CardLibrary.add(new Pellet());
        CardLibrary.add(new PoisonSlug());
        CardLibrary.add(new Quicksilver());
        CardLibrary.add(new ShockSlug());
        CardLibrary.add(new Tranquilizer());
        CardLibrary.add(new CoverFire());
        CardLibrary.add(new Desperado());
        CardLibrary.add(new FanTheHammer());
        CardLibrary.add(new IAmTheGun());
        CardLibrary.add(new Quickshot());
        CardLibrary.add(new Railgun());
        CardLibrary.add(new Repeater());
        CardLibrary.add(new Ricochet());
        CardLibrary.add(new ScrapLauncher());
        CardLibrary.add(new SpreadGun());
        CardLibrary.add(new XBeam());
        CardLibrary.add(new Barrier());
        CardLibrary.add(new DayOfTheDead());
        CardLibrary.add(new DoubleTap());
        CardLibrary.add(new GatlingArm());
        CardLibrary.add(new HiddenChamber());
        CardLibrary.add(new IronCross());
        CardLibrary.add(new LuckyBullet());
        CardLibrary.add(new MagicMagnet());
        CardLibrary.add(new Overflow());
        CardLibrary.add(new Reload());
        CardLibrary.add(new Reprogram());
        CardLibrary.add(new Sparklers());
        CardLibrary.add(new Stash());
        CardLibrary.add(new Transmute());
        CardLibrary.add(new Undo());
        CardLibrary.add(new CompressionMold());
        CardLibrary.add(new Incendiary());
        CardLibrary.add(new Munitions());
        CardLibrary.add(new PressureBubble());
        CardLibrary.add(new SystemUpdate());
        CardLibrary.add(new WarningShots());
    }

    private static void addColorlessCards() {
        CardLibrary.add(new Apotheosis());
        CardLibrary.add(new BandageUp());
        CardLibrary.add(new Blind());
        CardLibrary.add(new DarkShackles());
        CardLibrary.add(new DeepBreath());
        CardLibrary.add(new DramaticEntrance());
        CardLibrary.add(new Enlightenment());
        CardLibrary.add(new Finesse());
        CardLibrary.add(new FlashOfSteel());
        CardLibrary.add(new GoodInstincts());
        CardLibrary.add(new JackOfAllTrades());
        CardLibrary.add(new JAX());
        CardLibrary.add(new Madness());
        CardLibrary.add(new MasterOfStrategy());
        CardLibrary.add(new MindBlast());
        CardLibrary.add(new Panacea());
        CardLibrary.add(new Panache());
        CardLibrary.add(new Purity());
        CardLibrary.add(new SadisticNature());
        CardLibrary.add(new SecretTechnique());
        CardLibrary.add(new SecretWeapon());
        CardLibrary.add(new Shiv());
        CardLibrary.add(new SwiftStrike());
        CardLibrary.add(new ThinkingAhead());
        CardLibrary.add(new Transmutation());
        CardLibrary.add(new Trip());
    }

    private static void addCurseCards() {
        CardLibrary.add(new Clumsy());
        CardLibrary.add(new Decay());
        CardLibrary.add(new Doubt());
        CardLibrary.add(new Injury());
        CardLibrary.add(new Necronomicurse());
        CardLibrary.add(new Normality());
        CardLibrary.add(new Pain());
        CardLibrary.add(new Parasite());
        CardLibrary.add(new Regret());
        CardLibrary.add(new Writhe());
    }

    private static void removeNonFinalizedCards() {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Map.Entry<String, AbstractCard> c : cards.entrySet()) {
            if (c.getValue().assetURL != null) continue;
            toRemove.add(c.getKey());
        }
        for (String s : toRemove) {
            logger.info("Removing Card " + s + " for trailer build.");
            cards.remove(s);
        }
        toRemove.clear();
        for (Map.Entry<String, AbstractCard> c : curses.entrySet()) {
            if (c.getValue().assetURL != null) continue;
            toRemove.add(c.getKey());
        }
        for (String s : toRemove) {
            logger.info("Removing Curse " + s + " for trailer build.");
            curses.remove(s);
        }
    }

    public static void unlockAndSeeAllCards() {
        for (String string : UnlockTracker.lockedCards) {
            UnlockTracker.hardUnlockOverride(string);
        }
        for (Map.Entry entry : cards.entrySet()) {
            if (((AbstractCard)entry.getValue()).rarity == AbstractCard.CardRarity.BASIC || UnlockTracker.isCardSeen((String)entry.getKey())) continue;
            UnlockTracker.markCardAsSeen((String)entry.getKey());
        }
        for (Map.Entry entry : curses.entrySet()) {
            if (UnlockTracker.isCardSeen((String)entry.getKey())) continue;
            UnlockTracker.markCardAsSeen((String)entry.getKey());
        }
    }

    public static void add(AbstractCard card) {
        switch (card.color) {
            case RED: {
                ++redCards;
                if (!UnlockTracker.isCardSeen(card.cardID)) break;
                ++seenRedCards;
                break;
            }
            case GREEN: {
                ++greenCards;
                if (!UnlockTracker.isCardSeen(card.cardID)) break;
                ++seenGreenCards;
                break;
            }
            case BLUE: {
                ++blueCards;
                if (!UnlockTracker.isCardSeen(card.cardID)) break;
                ++seenBlueCards;
                break;
            }
            case COLORLESS: {
                ++colorlessCards;
                if (!UnlockTracker.isCardSeen(card.cardID)) break;
                ++seenColorlessCards;
                break;
            }
            case CURSE: {
                ++curseCards;
                if (UnlockTracker.isCardSeen(card.cardID)) {
                    ++seenCurseCards;
                }
                curses.put(card.cardID, card);
                break;
            }
        }
        if (!UnlockTracker.isCardSeen(card.cardID)) {
            card.isSeen = false;
        }
        cards.put(card.cardID, card);
        card.initializeDescription();
        ++totalCardCount;
    }

    public static AbstractCard getCopy(String key, int upgradeTime) {
        AbstractCard source = CardLibrary.getCard(key);
        AbstractCard retVal = null;
        retVal = source == null ? CardLibrary.getCard("Madness").makeCopy() : CardLibrary.getCard(key).makeCopy();
        for (int i = 0; i < upgradeTime; ++i) {
            retVal.upgrade();
        }
        return retVal;
    }

    public static AbstractCard getCopy(String key) {
        return CardLibrary.getCard(key).makeCopy();
    }

    public static AbstractCard getCard(AbstractPlayer.PlayerClass plyrClass, String key) {
        return cards.get(key);
    }

    public static AbstractCard getCard(String key) {
        return cards.get(key);
    }

    public static AbstractCard getCurse(int pool) {
        if (pool < 1 || pool > 2) {
            logger.info("INCORRECT POOL FOR GET CURSE");
        }
        ArrayList<String> tmp = new ArrayList<String>();
        for (Map.Entry<String, AbstractCard> c : curses.entrySet()) {
            if (c.getValue().pool != pool) continue;
            tmp.add(c.getKey());
        }
        return cards.get(tmp.get(MathUtils.random(0, tmp.size() - 1)));
    }

    public static AbstractCard getCurse(AbstractCard prohibitedCard, Random rng) {
        ArrayList<String> tmp = new ArrayList<String>();
        for (Map.Entry<String, AbstractCard> c : curses.entrySet()) {
            if (Objects.equals(c.getValue().cardID, prohibitedCard.cardID) || Objects.equals(c.getValue().cardID, "Necronomicurse")) continue;
            tmp.add(c.getKey());
        }
        return cards.get(tmp.get(rng.random(0, tmp.size() - 1)));
    }

    public static AbstractCard getCurse(AbstractCard prohibitedCard) {
        return CardLibrary.getCurse(prohibitedCard, new Random());
    }

    public static void uploadCardData() {
        ArrayList<String> data = new ArrayList<String>();
        for (Map.Entry<String, AbstractCard> c : cards.entrySet()) {
            data.add(c.getValue().debugDetailedCardDataString());
            AbstractCard c2 = c.getValue().makeCopy();
            if (!c2.canUpgrade()) continue;
            c2.upgrade();
            data.add(c2.debugDetailedCardDataString());
        }
        LeaderboardPoster poster = new LeaderboardPoster();
        poster.setValues(LeaderboardPoster.LeaderboardDataType.CARD_DATA, "", AbstractCard.debugDetailedCardDataHeader(), data, false);
        Thread t = new Thread(poster);
        t.run();
    }

    public static ArrayList<AbstractCard> getAllCards() {
        ArrayList<AbstractCard> retVal = new ArrayList<AbstractCard>();
        for (Map.Entry<String, AbstractCard> c : cards.entrySet()) {
            retVal.add(c.getValue());
        }
        return retVal;
    }

    public static ArrayList<AbstractCard> getCardList(LibraryType type) {
        ArrayList<AbstractCard> retVal = new ArrayList<AbstractCard>();
        switch (type) {
            case COLORLESS: {
                for (Map.Entry<String, AbstractCard> c : cards.entrySet()) {
                    if (c.getValue().color != AbstractCard.CardColor.COLORLESS) continue;
                    retVal.add(c.getValue());
                }
                break;
            }
            case CURSE: {
                for (Map.Entry<String, AbstractCard> c : cards.entrySet()) {
                    if (c.getValue().color != AbstractCard.CardColor.CURSE) continue;
                    retVal.add(c.getValue());
                }
                break;
            }
            case RED: {
                for (Map.Entry<String, AbstractCard> c : cards.entrySet()) {
                    if (c.getValue().color != AbstractCard.CardColor.RED) continue;
                    retVal.add(c.getValue());
                }
                break;
            }
            case GREEN: {
                for (Map.Entry<String, AbstractCard> c : cards.entrySet()) {
                    if (c.getValue().color != AbstractCard.CardColor.GREEN) continue;
                    retVal.add(c.getValue());
                }
                break;
            }
            case BLUE: {
                for (Map.Entry<String, AbstractCard> c : cards.entrySet()) {
                    if (c.getValue().color != AbstractCard.CardColor.BLUE) continue;
                    retVal.add(c.getValue());
                }
                break;
            }
            case STATUS: {
                retVal.add(new Wound());
                retVal.add(new Burn());
                retVal.add(new Dazed());
                break;
            }
        }
        return retVal;
    }

    public static enum LibraryType {
        RED,
        GREEN,
        BLUE,
        CURSE,
        STATUS,
        COLORLESS;

    }
}

